namespace org.owasp.appsensor
{

    using System;
    using System.Web;
    using System.Globalization;
    using Owasp.Esapi;
    using Owasp.Esapi.Errors;
    using System.Web.SessionState;
    using System.Collections.Generic;

    public class AppSensorSystemUser : ASUser
    {

        /**
         * The system user is used to represent an user in the case that an exception 
         * is thrown that is not in the context of a user, ie. an AppSensorSystemException. 
         * Since there is always a real user, the system user is better than using null to represent this.
         */
        private const long serialVersionUID = 5716176095812125529L;

        private String csrfToken = "";
        private ISet<HttpSessionState> sessions = new HashSet<HttpSessionState>();
        private CultureInfo locale = null;

        private const String SYSTEM_USER = "APP_SENSOR_SYSTEM_USER";

        /**
         * {@inheritDoc}
         */
        public void AddRole(String role)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void AddRoles(ISet<String> newRoles)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void ChangePassword(String oldPassword, String newPassword1, String newPassword2)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void Disable()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void Enable()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public long AccountId
        {
            get
            {
                return -100;
            }
        }

        /**
         * {@inheritDoc}
         */
        public String AccountName
        {
            get
            {
                return SYSTEM_USER;
            }
        }

        /**
         * Alias method that is equivalent to getAccountName()
         * 
         * @return the name of the current user's account
         */
        public String Name
        {
            get
            {
                return AccountName;
            }
        }

        /**
         * {@inheritDoc}
         */
        public String GetCSRFToken()
        {
            return csrfToken;
        }

        /**
         * {@inheritDoc}
         */
        public DateTime GetExpirationTime()
        {
            return DateTime.MinValue;
        }

        /**
         * {@inheritDoc}
         */
        public int GetFailedLoginCount()
        {
            return 0;
        }

        /**
         * {@inheritDoc}
         */
        public DateTime GetLastFailedLoginTime()
        {
            return DateTime.MinValue;
        }

        /**
         * {@inheritDoc}
         */
        public String GetLastHostAddress()
        {
            return "unknown";
        }

        /**
         * {@inheritDoc}
         */
        public DateTime GetLastLoginTime()
        {
            return DateTime.MinValue;
        }

        /**
         * {@inheritDoc}
         */
        public DateTime GetLastPasswordChangeTime()
        {
            return DateTime.MinValue;
        }

        /**
         * {@inheritDoc}
         */
        public ISet<String> GetRoles()
        {
            return new HashSet<String>();
        }

        /**
         * {@inheritDoc}
         */
        public String GetScreenName()
        {
            return SYSTEM_USER;
        }

        /**
         * {@inheritDoc}
         */
        public void AddSession(HttpSessionState s)
        {
        }

        /**
         * {@inheritDoc}
         */
        public void RemoveSession(HttpSessionState s)
        {
        }

        /**
         * {@inheritDoc}
         */
        public ISet<HttpSessionState> GetSessions()
        {
            return sessions;
        }

        /**
         * {@inheritDoc}
         */
        public void IncrementFailedLoginCount()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public bool Anonymous
        {
            get
            {
                return true;
            }
        }

        /**
         * {@inheritDoc}
         */
        public bool Enabled
        {
            get
            {
                return false;
            }
        }

        /**
         * {@inheritDoc}
         */
        public bool IsExpired()
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public bool IsInRole(String role)
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public bool IsLocked()
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public bool IsLoggedIn()
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public bool IsSessionAbsoluteTimeout()
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public bool IsSessionTimeout()
        {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public void Lock()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void LoginWithPassword(String password)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void Logout()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void RemoveRole(String role)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public String ResetCSRFToken()
        {
            csrfToken = Esapi.Randomizer.GetRandomString(8, CharSetValues.Alphanumerics);
            return csrfToken;
        }

        /**
         * {@inheritDoc}
         */
        public void SetAccountName(String accountName)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetExpirationTime(DateTime expirationTime)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetRoles(ISet<String> roles)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetScreenName(String screenName)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void Unlock()
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public bool VerifyPassword(String password)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetLastFailedLoginTime(DateTime lastFailedLoginTime)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetLastLoginTime(DateTime lastLoginTime)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetLastHostAddress(String remoteHost)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        public void SetLastPasswordChangeTime(DateTime lastPasswordChangeTime)
        {
            throw new InvalidOperationException("Invalid operation for the system user");
        }

        /**
         * {@inheritDoc}
         */
        //public Dictionary<string, Owasp.Esapi.Event> getEventMap()
        //{
        //    throw new InvalidOperationException("Invalid operation for the system user");
        //}

        /**
         * @return the locale
         */
        public CultureInfo Locale
        {
            get
            {
                return locale;
            }
            set
            {
                locale = value;
            }
        }
    }
}